#include <GL/glut.h>   
#include <stdio.h>

float rx, ry, rz;

void display()
{
  glClear(GL_COLOR_BUFFER_BIT);
  glColor3f(0.5, 0.4, 1.0);
  glPushMatrix();
  glRotatef(rx, 1.0, 0.0, 0.0);
  glRotatef(ry, 0.0, 1.0, 0.0);
  glRotatef(rz, 0.0, 0.0, 1.0);
  glutWireTeapot(0.5);
  glPopMatrix();
  glutSwapBuffers();
}

void keyboard(unsigned char key, int x, int y)
{
  //print *, 'Key ', char(key),  key, ' at', x, y
  fprintf (stderr,"Key %c at %d, %d\n", key, x, y);
  if (key=='x') 
    rx = rx + 5.0;
  if (key=='y') 
    ry = ry + 5.0;
  if (key=='z') 
    rz = rz + 5.0;
  glutPostRedisplay();
}

int main(int argc, char *argv[])
{
  glutInit(&argc, argv);
  glutInitDisplayMode(GLUT_DOUBLE|GLUT_RGB);
  glutCreateWindow("Use keys x, y, and z");
  glutDisplayFunc(display);
  glutKeyboardFunc(keyboard);
  glutMainLoop();
  return 0;
} 
