#include <stdio.h>
#include <stdlib.h>
#include <GL/glut.h>

#define MAXN 100

GLint n;
GLfloat *vertex;

void redraw()
{
  int i;
  glClear(GL_COLOR_BUFFER_BIT);
  glPushMatrix();
  glColor3f(1,1,1);
  glBegin(GL_LINE_STRIP);
  for (i = 0; i < n; i++)
  {
    glVertex2fv(&vertex[i*2]);
  }
  glEnd();
  
  for (i = 0; i < n; i++) //Adding spheres on world coords
  {
  glColor3f(1,0,0);
  glPushMatrix();
  glTranslatef(vertex[i*2],vertex[i*2+1],0); 
  glutSolidSphere(0.01,8,8); 
  glPopMatrix();
  }
  glPopMatrix();
  glutSwapBuffers();
}

void mouse(int button, int state, int x, int y)
{
  GLint viewport[4];
  GLdouble mvmatrix[16], projmatrix[16];
  GLdouble wx, wy, wz; //World x, y, z coords 
  GLdouble px, py, pz; //Picked window coordinates 
  int status;
  if (button == GLUT_LEFT_BUTTON )
  {
  if (state == GLUT_DOWN) 
    {
      glGetIntegerv (GL_VIEWPORT, viewport);
      glGetDoublev (GL_MODELVIEW_MATRIX, mvmatrix);
      glGetDoublev (GL_PROJECTION_MATRIX, projmatrix);
      //Note viewport[4] is height in pixels 
      px = x;
      py = viewport[3] - y - 1;
      pz = 0.0;
      fprintf (stderr, "Coordinates at cursor are %f, %f\n", px, py);
      status = gluUnProject (px, py, pz, mvmatrix, projmatrix, viewport, &wx, &wy, &wz);
      fprintf(stderr, "World coords at z=0.0 are %f, %f, %f\n", wx, wy, wz);
      if (n < MAXN) 
      {
        vertex[n*2] = wx; 
        vertex[n*2+1] = wy;
        n=n+1;
      }       
      else
      {
        fprintf(stderr, "Maximum number of points was recieved!\n");
      }
      glutPostRedisplay();
    }
  }
}

/**************************** Glavni program **************************************/

int main(int argc, char *argv[])
{ 
  vertex = (GLfloat *) malloc(2 * MAXN * sizeof (GLfloat)); 
  glutInit(&argc, argv);
  glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
  glutInitWindowSize (700, 700);
  glutInitWindowPosition (0, 0);
  glutCreateWindow("Click in window");
  glutDisplayFunc(redraw); 
  glutMouseFunc(mouse);
  glutMainLoop();
  return 0;
}
